import { _ as _sfc_main$1 } from "./FirstTitle-jarWvN-b.js";
import { a as useNuxtApp, e as useMaghaleStore, g as useRoute, b as useRuntimeConfig } from "../server.mjs";
import { reactive, ref, mergeProps, unref, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrRenderComponent, ssrRenderAttr, ssrInterpolate, ssrRenderList } from "vue/server-renderer";
import axios from "axios";
import "compressorjs";
const _sfc_main = {
  __name: "form",
  __ssrInlineRender: true,
  setup(__props) {
    const { $CustomAlert } = useNuxtApp();
    const store = useMaghaleStore();
    const id = useRoute().params.id;
    const handoutData = reactive({ data: { handout: 0 }, activity: {} });
    async function getHandout() {
      axios.defaults.headers.common.Authorization = store.token;
      await axios.get(useRuntimeConfig().public.BaseUrl + "maghale/get_handout_edit/" + id).then((r) => {
        handoutData.activity = r.data.activity;
        handoutData.data = r.data;
        delete handoutData.data.activity;
      });
    }
    getHandout();
    ref(null);
    return (_ctx, _push, _parent, _attrs) => {
      const _component_MaghaleFirstTitle = _sfc_main$1;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "" }, _attrs))}>`);
      _push(ssrRenderComponent(_component_MaghaleFirstTitle, { title: "ویرایش دست‌نوشته" }, null, _parent));
      _push(`<div><label for="title" class="block mt-6 text-sm font-medium text-zinc-900 dark:text-white">عنوان</label><input type="text" id="title"${ssrRenderAttr("value", unref(handoutData).activity.title)} class="mt-2 bg-zinc-50 border border-zinc-300 text-zinc-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-zinc-700 dark:border-zinc-600 dark:placeholder-zinc-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" required></div><div><label for="abstract" class="block mt-4 text-sm font-medium text-zinc-900 dark:text-white"> خلاصه</label><textarea type="text" id="abstract" class="mt-2 bg-zinc-50 border border-zinc-300 text-zinc-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-zinc-700 dark:border-zinc-600 dark:placeholder-zinc-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">${ssrInterpolate(unref(handoutData).activity.abstract)}</textarea></div><div class="mt-4 grid gap-2 grid-cols-3 text-zinc-800 dark:text-white"><!--[-->`);
      ssrRenderList(unref(handoutData).activity.images, (image) => {
        _push(`<div class="text-center"><img${ssrRenderAttr("src", ("useRuntimeConfig" in _ctx ? _ctx.useRuntimeConfig : unref(useRuntimeConfig))().public.MediaUrl + image.image)} class="size-20 rounded-lg mx-auto"><button type="button" class="w-20 mt-1 rounded-lg bg-zinc-300"><svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-6 mx-auto p-0.5"><path stroke-linecap="round" stroke-linejoin="round" d="m14.74 9-.346 9m-4.788 0L9.26 9m9.968-3.21c.342.052.682.107 1.022.166m-1.022-.165L18.16 19.673a2.25 2.25 0 0 1-2.244 2.077H8.084a2.25 2.25 0 0 1-2.244-2.077L4.772 5.79m14.456 0a48.108 48.108 0 0 0-3.478-.397m-12 .562c.34-.059.68-.114 1.022-.165m0 0a48.11 48.11 0 0 1 3.478-.397m7.5 0v-.916c0-1.18-.91-2.164-2.09-2.201a51.964 51.964 0 0 0-3.32 0c-1.18.037-2.09 1.022-2.09 2.201v.916m7.5 0a48.667 48.667 0 0 0-7.5 0"></path></svg></button></div>`);
      });
      _push(`<!--]--></div><div class="mt-4"><div class=""><label class="block mb-2 text-sm font-medium text-zinc-900 dark:text-white">افزودن عکس</label><input type="file" accept="image/*" class="block mb-2 p-2.5 w-full text-sm text-zinc-900 bg-zinc-50 rounded-lg border border-zinc-300 focus:ring-blue-500 focus:border-blue-500 dark:bg-zinc-700 dark:border-zinc-600 dark:placeholder-zinc-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500"></div></div></div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/handout/edit/form.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as _
};
//# sourceMappingURL=form-DAGYfFGt.js.map
