import { unref, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrRenderAttr } from "vue/server-renderer";
import { a as useNuxtApp, e as useMaghaleStore, f as useRouter } from "../server.mjs";
const _sfc_main = {
  __name: "status",
  __ssrInlineRender: true,
  props: ["instance"],
  setup(__props) {
    const { $CustomAlert } = useNuxtApp();
    useMaghaleStore();
    const props = __props;
    const instance = props.instance;
    useRouter();
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(_attrs)}>`);
      if (unref(instance).work.status) {
        _push(`<select id="states" class="bg-zinc-50 border border-zinc-300 text-zinc-900 text-xs rounded-lg border-s-2 focus:ring-blue-500 focus:border-blue-500 block p-1 dark:bg-zinc-700 dark:border-zinc-600 dark:placeholder-zinc-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500"><option selected${ssrRenderAttr("value", 1)}>در صف مطالعه</option><option selected${ssrRenderAttr("value", 2)}>در حال مطالعه</option><option selected${ssrRenderAttr("value", 3)}>روزنامه‌وار</option><option selected${ssrRenderAttr("value", 4)}>تنها کمی ابهام</option><option selected${ssrRenderAttr("value", 5)}>مطالعه کامل</option><option selected${ssrRenderAttr("value", 6)}>انصراف از مطالعه</option></select>`);
      } else {
        _push(`<button class="bg-zinc-100 text-zinc-800 text-xs font-medium me-2 px-2.5 py-0.5 rounded-sm dark:bg-zinc-800 dark:text-zinc-400 border border-zinc-400"> افزودن به لیست</button>`);
      }
      _push(`</div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/activity/status.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as _
};
//# sourceMappingURL=status-D3scJwW-.js.map
