import { e as useMaghaleStore, _ as __nuxt_component_0, b as useRuntimeConfig, a as useNuxtApp, f as useRouter } from './server.mjs';
import { mergeProps, unref, withCtx, createBlock, createTextVNode, openBlock, createVNode, toDisplayString, reactive, ref, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrRenderComponent, ssrInterpolate, ssrRenderAttr } from 'vue/server-renderer';
import { _ as _sfc_main$3 } from './FirstTitle-jarWvN-b.mjs';
import { _ as _export_sfc } from './_plugin-vue_export-helper-1tPrXgE0.mjs';
import '../_/nitro.mjs';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'node:fs';
import 'node:path';
import 'node:crypto';
import 'node:url';
import '../routes/renderer.mjs';
import 'vue-bundle-renderer/runtime';
import 'unhead/server';
import 'devalue';
import 'unhead/plugins';
import 'unhead/utils';
import 'pinia';
import 'vue-router';
import 'deep-pick-omit';
import 'sweetalert2';
import 'axios';

const _sfc_main$2 = {
  __name: "Breadcrumb",
  __ssrInlineRender: true,
  setup(__props) {
    const store = useMaghaleStore();
    return (_ctx, _push, _parent, _attrs) => {
      const _component_NuxtLink = __nuxt_component_0;
      _push(`<nav${ssrRenderAttrs(mergeProps({
        dir: "rtl",
        class: "flex text-xs",
        "aria-label": "Breadcrumb"
      }, _attrs))}><ol class="inline-flex items-center space-x-1 md:space-x-2 rtl:space-x-reverse py-2"><li class="inline-flex items-center">`);
      _push(ssrRenderComponent(_component_NuxtLink, {
        to: ("useRuntimeConfig" in _ctx ? _ctx.useRuntimeConfig : unref(useRuntimeConfig))().public.router.Home,
        class: "inline-flex items-center font-medium text-zinc-700 hover:text-blue-600 dark:text-zinc-400 dark:hover:text-white"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<svg class="w-3 h-3 me-2.5" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20"${_scopeId}><path d="m19.707 9.293-2-2-7-7a1 1 0 0 0-1.414 0l-7 7-2 2a1 1 0 0 0 1.414 1.414L2 10.414V18a2 2 0 0 0 2 2h3a1 1 0 0 0 1-1v-4a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v4a1 1 0 0 0 1 1h3a2 2 0 0 0 2-2v-7.586l.293.293a1 1 0 0 0 1.414-1.414Z"${_scopeId}></path></svg> \u062E\u0627\u0646\u0647 `);
          } else {
            return [
              (openBlock(), createBlock("svg", {
                class: "w-3 h-3 me-2.5",
                "aria-hidden": "true",
                xmlns: "http://www.w3.org/2000/svg",
                fill: "currentColor",
                viewBox: "0 0 20 20"
              }, [
                createVNode("path", { d: "m19.707 9.293-2-2-7-7a1 1 0 0 0-1.414 0l-7 7-2 2a1 1 0 0 0 1.414 1.414L2 10.414V18a2 2 0 0 0 2 2h3a1 1 0 0 0 1-1v-4a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v4a1 1 0 0 0 1 1h3a2 2 0 0 0 2-2v-7.586l.293.293a1 1 0 0 0 1.414-1.414Z" })
              ])),
              createTextVNode(" \u062E\u0627\u0646\u0647 ")
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</li><li aria-current="page">`);
      _push(ssrRenderComponent(_component_NuxtLink, {
        to: ("useRuntimeConfig" in _ctx ? _ctx.useRuntimeConfig : unref(useRuntimeConfig))().public.router.Book + unref(store).book.id,
        class: "flex items-center"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<svg class="rtl:rotate-180 w-3 h-3 text-zinc-400 mx-1" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 6 10"${_scopeId}><path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 9 4-4-4-4"${_scopeId}></path></svg><span class="ms-1 font-medium text-zinc-500 md:ms-2 dark:text-zinc-400"${_scopeId}>${ssrInterpolate(unref(store).book.get_title)}</span>`);
          } else {
            return [
              (openBlock(), createBlock("svg", {
                class: "rtl:rotate-180 w-3 h-3 text-zinc-400 mx-1",
                "aria-hidden": "true",
                xmlns: "http://www.w3.org/2000/svg",
                fill: "none",
                viewBox: "0 0 6 10"
              }, [
                createVNode("path", {
                  stroke: "currentColor",
                  "stroke-linecap": "round",
                  "stroke-linejoin": "round",
                  "stroke-width": "2",
                  d: "m1 9 4-4-4-4"
                })
              ])),
              createVNode("span", { class: "ms-1 font-medium text-zinc-500 md:ms-2 dark:text-zinc-400" }, toDisplayString(unref(store).book.get_title), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</li><li aria-current="page">`);
      _push(ssrRenderComponent(_component_NuxtLink, {
        to: ("useRuntimeConfig" in _ctx ? _ctx.useRuntimeConfig : unref(useRuntimeConfig))().public.router.Chapter + unref(store).chapter.id,
        class: "flex items-center"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<svg class="rtl:rotate-180 w-3 h-3 text-zinc-400 mx-1" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 6 10"${_scopeId}><path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 9 4-4-4-4"${_scopeId}></path></svg><span class="ms-1 font-medium text-zinc-500 md:ms-2 dark:text-zinc-400"${_scopeId}>${ssrInterpolate(unref(store).chapter.get_title)}</span>`);
          } else {
            return [
              (openBlock(), createBlock("svg", {
                class: "rtl:rotate-180 w-3 h-3 text-zinc-400 mx-1",
                "aria-hidden": "true",
                xmlns: "http://www.w3.org/2000/svg",
                fill: "none",
                viewBox: "0 0 6 10"
              }, [
                createVNode("path", {
                  stroke: "currentColor",
                  "stroke-linecap": "round",
                  "stroke-linejoin": "round",
                  "stroke-width": "2",
                  d: "m1 9 4-4-4-4"
                })
              ])),
              createVNode("span", { class: "ms-1 font-medium text-zinc-500 md:ms-2 dark:text-zinc-400" }, toDisplayString(unref(store).chapter.get_title), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</li></ol></nav>`);
    };
  }
};
const _sfc_setup$2 = _sfc_main$2.setup;
_sfc_main$2.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/chapter/Breadcrumb.vue");
  return _sfc_setup$2 ? _sfc_setup$2(props, ctx) : void 0;
};
const _sfc_main$1 = {
  __name: "addForm",
  __ssrInlineRender: true,
  setup(__props) {
    const { $CustomAlert } = useNuxtApp();
    const store = useMaghaleStore();
    useRouter();
    reactive({
      chapter: store.chapter.id
    });
    const activity = reactive({
      title: "",
      abstract: ""
    });
    ref(0);
    ref(null);
    const imagePreview = ref(null);
    return (_ctx, _push, _parent, _attrs) => {
      const _component_MaghaleFirstTitle = _sfc_main$3;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "" }, _attrs))}>`);
      _push(ssrRenderComponent(_component_MaghaleFirstTitle, { title: "\u0627\u0641\u0632\u0648\u062F\u0646 \u0628\u062E\u0634" }, null, _parent));
      _push(`<form class="max-w-sm mx-auto" dir="rtl"><div><div class="mt-4"><label for="title" class="block mb-2 font-medium text-zinc-900 dark:text-white">\u0639\u0646\u0648\u0627\u0646</label><input${ssrRenderAttr("value", unref(activity).title)} type="text" id="title" class="shadow-sm bg-zinc-50 border border-zinc-300 text-zinc-900 rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-zinc-700 dark:border-zinc-600 dark:placeholder-zinc-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500 dark:shadow-sm-light" required></div><div class="mt-4"><label for="message" class="block mb-2 text-sm font-medium text-zinc-900 dark:text-white"> \u062A\u0648\u0636\u06CC\u062D\u0627\u062A \u0645\u062E\u062A\u0635\u0631 </label><textarea id="message" rows="2" class="block mb-2 p-2.5 w-full text-sm text-zinc-900 bg-zinc-50 rounded-lg border border-zinc-300 focus:ring-blue-500 focus:border-blue-500 dark:bg-zinc-700 dark:border-zinc-600 dark:placeholder-zinc-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" placeholder="">${ssrInterpolate(unref(activity).abstract)}</textarea></div>`);
      if (unref(imagePreview)) {
        _push(`<div class="flex flex-col space-y-1 mt-4"><img${ssrRenderAttr("src", unref(imagePreview))} alt="Preview" class="rounded-lg size-20 mx-auto"><button type="button" class="w-20 rounded-lg bg-yellow-300 mx-auto"><svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-6 mx-auto p-0.5"><path stroke-linecap="round" stroke-linejoin="round" d="m14.74 9-.346 9m-4.788 0L9.26 9m9.968-3.21c.342.052.682.107 1.022.166m-1.022-.165L18.16 19.673a2.25 2.25 0 0 1-2.244 2.077H8.084a2.25 2.25 0 0 1-2.244-2.077L4.772 5.79m14.456 0a48.108 48.108 0 0 0-3.478-.397m-12 .562c.34-.059.68-.114 1.022-.165m0 0a48.11 48.11 0 0 1 3.478-.397m7.5 0v-.916c0-1.18-.91-2.164-2.09-2.201a51.964 51.964 0 0 0-3.32 0c-1.18.037-2.09 1.022-2.09 2.201v.916m7.5 0a48.667 48.667 0 0 0-7.5 0"></path></svg></button></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class=""><label class="block mb-2 text-sm font-medium text-zinc-900 dark:text-white">\u0627\u0646\u062A\u062E\u0627\u0628 \u0639\u06A9\u0633</label><input type="file" accept="image/*" class="block mb-2 p-2.5 w-full text-sm text-zinc-900 bg-zinc-50 rounded-lg border border-zinc-300 focus:ring-blue-500 focus:border-blue-500 dark:bg-zinc-700 dark:border-zinc-600 dark:placeholder-zinc-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500"></div></div><div class="flex mt-4"><button type="submit" class="text-white ml-2 bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-lg px-3 py-2.5 text-center dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">\u062B\u0628\u062A \u0648 \u0628\u0631\u06AF\u0634\u062A </button><button type="button" class="text-white ml-2 bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-lg px-3 py-2.5 text-center dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">\u062B\u0628\u062A \u0648 \u062A\u06A9\u0645\u06CC\u0644</button><button type="button" class="text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-lg px-3 py-2.5 text-center dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">\u062B\u0628\u062A \u0648 \u0627\u0641\u0632\u0648\u062F\u0646 \u0628\u0639\u062F\u06CC </button></div></form></div>`);
    };
  }
};
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/section/addForm.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const _sfc_main = {};
function _sfc_ssrRender(_ctx, _push, _parent, _attrs) {
  const _component_ChapterBreadcrumb = _sfc_main$2;
  const _component_SectionAddForm = _sfc_main$1;
  _push(`<div${ssrRenderAttrs(_attrs)}><div class="">`);
  _push(ssrRenderComponent(_component_ChapterBreadcrumb, null, null, _parent));
  _push(ssrRenderComponent(_component_SectionAddForm, null, null, _parent));
  _push(`</div></div>`);
}
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("pages/sections/add.client.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const add_client = /* @__PURE__ */ _export_sfc(_sfc_main, [["ssrRender", _sfc_ssrRender]]);

export { add_client as default };
//# sourceMappingURL=add.client-DA8-gc6K.mjs.map
