import { _ as _sfc_main$1 } from './FirstTitle-jarWvN-b.mjs';
import { e as useMaghaleStore, b as useRuntimeConfig, c as _sfc_main$5 } from './server.mjs';
import { reactive, unref, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrRenderComponent, ssrRenderAttr, ssrInterpolate } from 'vue/server-renderer';
import axios from 'axios';

const _sfc_main = {
  __name: "index",
  __ssrInlineRender: true,
  setup(__props) {
    const store = useMaghaleStore();
    const id = store.activity.id;
    const activity = reactive({ data: {} });
    async function getActivity() {
      let url = useRuntimeConfig().public.BaseUrl + "maghale/";
      store.isAuthenticated ? url = url + "get_activity_by_user/" : url = url + "get_activity/";
      await axios.get(url + id).then((r) => {
        activity.data = r.data;
      });
    }
    getActivity();
    return (_ctx, _push, _parent, _attrs) => {
      const _component_MaghaleFirstTitle = _sfc_main$1;
      const _component_UserProfile = _sfc_main$5;
      _push(`<div${ssrRenderAttrs(_attrs)}><div class="flex justify-between gap-x-2">`);
      if (unref(activity).data.title) {
        _push(ssrRenderComponent(_component_MaghaleFirstTitle, {
          title: unref(activity).data.title
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      if (unref(activity).data.get_image) {
        _push(`<img${ssrRenderAttr("src", ("useRuntimeConfig" in _ctx ? _ctx.useRuntimeConfig : unref(useRuntimeConfig))().public.MediaUrl + unref(activity).data.get_image)} alt="" class="size-24 object-cover rounded-lg">`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div><p class="mt-4 text-xs font-normal text-zinc-700 dark:text-zinc-200">${ssrInterpolate(unref(activity).data.abstract)}</p>`);
      if (unref(activity).data.user) {
        _push(ssrRenderComponent(_component_UserProfile, {
          user: unref(activity).data.user,
          class: "mt-4"
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/activity/index.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as _ };
//# sourceMappingURL=index-C9kUGn43.mjs.map
