import { b as useRuntimeConfig, f as useRouter, e as useMaghaleStore, a as useNuxtApp } from './server.mjs';
import { reactive, unref, mergeProps, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrRenderList, ssrRenderComponent, ssrRenderAttr, ssrInterpolate } from 'vue/server-renderer';
import axios from 'axios';
import '../_/nitro.mjs';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'node:fs';
import 'node:path';
import 'node:crypto';
import 'node:url';
import '../routes/renderer.mjs';
import 'vue-bundle-renderer/runtime';
import 'unhead/server';
import 'devalue';
import 'unhead/plugins';
import 'unhead/utils';
import 'pinia';
import 'vue-router';
import 'deep-pick-omit';
import 'sweetalert2';

const _sfc_main$2 = {
  __name: "reply",
  __ssrInlineRender: true,
  props: ["instance"],
  setup(__props) {
    const { $toPersianNumbers } = useNuxtApp();
    const toPersianNumbers = $toPersianNumbers;
    const props = __props;
    const instance = props.instance;
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "mr-6 mt-2" }, _attrs))}><span class="absolute flex items-center justify-center w-6 h-6 bg-cyen-100 -start-3 rounded-full dark:bg-cyen-950"><img class="rounded-full shadow-lg"${ssrRenderAttr("src", ("useRuntimeConfig" in _ctx ? _ctx.useRuntimeConfig : unref(useRuntimeConfig))().public.MediaUrl + unref(instance).user.get_image)} alt="Thomas Lean image"></span><div class="flex"><div class="p-1 bg-white text-xs border border-cyen-200 rounded-lg shadow-sm dark:bg-cyen-950 dark:border-cyen-600"><div class="flex items-center justify-between mb-1"><div class="font-normal text-cyen-500 dark:text-cyen-300">${ssrInterpolate(unref(instance).user.get_title)}</div><time class="mb-1 font-extralight text-xs text-cyen-400 mr-2">${ssrInterpolate(unref(toPersianNumbers)(unref(instance).persian_date))}</time></div><div class="p-1 text-xs italic font-normal text-cyen-500 border border-cyen-200 rounded-lg bg-cyen-50 dark:bg-cyen-800 dark:border-cyen-500 dark:text-cyen-100">${ssrInterpolate(unref(instance).text)}</div></div><div class="flex flex-col items-center"><button id="dropdownMenuIconButton"${ssrRenderAttr("data-dropdown-toggle", "id-" + unref(instance).id)} data-dropdown-placement="bottom-start" class="inline-flex self-center items-center p-2 m-2 font-medium text-center text-cyen-950 bg-white rounded-lg hover:bg-cyen-100 focus:ring-4 focus:outline-none dark:text-white focus:ring-cyen-50 dark:bg-cyen-950 dark:hover:bg-cyen-800 dark:focus:ring-cyen-600" type="button"><svg class="w-4 h-4 text-cyen-500 dark:text-cyen-400" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 4 15"><path d="M3.5 1.5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0Zm0 6.041a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0Zm0 5.959a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0Z"></path></svg></button><button type="button" class="flex -space-x-3 text-green-700"><svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-4"><path stroke-linecap="round" stroke-linejoin="round" d="m4.5 12.75 6 6 9-13.5"></path></svg>`);
      if (unref(instance).seen) {
        _push(`<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-4"><path stroke-linecap="round" stroke-linejoin="round" d="m4.5 12.75 6 6 9-13.5"></path></svg>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</button></div></div></div>`);
    };
  }
};
const _sfc_setup$2 = _sfc_main$2.setup;
_sfc_main$2.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/user/reply.vue");
  return _sfc_setup$2 ? _sfc_setup$2(props, ctx) : void 0;
};
const _sfc_main$1 = {
  __name: "comment-reply",
  __ssrInlineRender: true,
  props: ["instance"],
  setup(__props) {
    useRouter();
    const props = __props;
    const instance = props.instance;
    const store = useMaghaleStore();
    reactive({});
    return (_ctx, _push, _parent, _attrs) => {
      const _component_UserReply = _sfc_main$2;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "mb-4 ms-6" }, _attrs))}><div><span class="absolute flex items-center justify-center w-6 h-6 bg-blue-100 -start-3 rounded-full dark:bg-blue-950"><img class="rounded-full shadow-lg"${ssrRenderAttr("src", ("useRuntimeConfig" in _ctx ? _ctx.useRuntimeConfig : unref(useRuntimeConfig))().public.MediaUrl + unref(store).me.get_image)} alt="Thomas Lean image"></span><div class="flex"><div class="p-1 bg-white border border-cyen-200 rounded-lg shadow-sm dark:bg-cyen-950 dark:border-cyen-600"><div class="flex items-center"><p class="mb-1 font-extralight text-xs text-cyen-400">${ssrInterpolate(unref(instance).comment.activity.title)}</p>`);
      if (unref(instance).comment.activity.content) {
        _push(`<button type="button" class="text-cyen-700 dark:text-white"><svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-4 mr-1"><path stroke-linecap="round" stroke-linejoin="round" d="M21 16.811c0 .864-.933 1.406-1.683.977l-7.108-4.061a1.125 1.125 0 0 1 0-1.954l7.108-4.061A1.125 1.125 0 0 1 21 8.689v8.122ZM11.25 16.811c0 .864-.933 1.406-1.683.977l-7.108-4.061a1.125 1.125 0 0 1 0-1.954l7.108-4.061a1.125 1.125 0 0 1 1.683.977v8.122Z"></path></svg></button>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div><div class="p-1 text-xs italic font-normal text-cyen-500 border border-cyen-200 rounded-lg bg-cyen-50 dark:bg-cyen-800 dark:border-cyen-500 dark:text-cyen-300">${ssrInterpolate(unref(instance).comment.text)}</div></div><div${ssrRenderAttr("id", "id-" + unref(instance).id)} class="z-10 hidden bg-white divide-y divide-cyen-100 rounded-lg shadow w-40 dark:bg-cyen-700 dark:divide-cyen-600"><ul class="py-2 text-cyen-700 dark:text-cyen-200" aria-labelledby="dropdownMenuIconButton"><li><button class="block px-4 py-2 hover:bg-cyen-100 dark:hover:bg-cyen-600 dark:hover:text-white">\u067E\u0627\u0633\u062E</button></li><li><a href="#" class="block px-4 py-2 hover:bg-cyen-100 dark:hover:bg-cyen-600 dark:hover:text-white">\u06AF\u0632\u0627\u0631\u0634</a></li></ul></div></div></div><ol dir="rtl" class="relative border-s border-cyen-200 dark:border-cyen-700 m-4"><li>`);
      _push(ssrRenderComponent(_component_UserReply, { instance: unref(instance) }, null, _parent));
      _push(`</li></ol></div>`);
    };
  }
};
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/user/comment-reply.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const _sfc_main = {
  __name: "replies",
  __ssrInlineRender: true,
  setup(__props) {
    const replies = reactive({
      next: useRuntimeConfig().public.BaseUrl + "maghale/my_replies/",
      data: []
    });
    getComments();
    async function getComments() {
      await axios.get(replies.next).then((r) => {
        replies.data = replies.data.concat(r.data.results);
        replies.next = r.data.next;
      });
    }
    return (_ctx, _push, _parent, _attrs) => {
      const _component_UserCommentReply = _sfc_main$1;
      _push(`<div${ssrRenderAttrs(_attrs)}><ol dir="rtl" class="relative border-s border-cyen-200 dark:border-cyen-700 m-4"><!--[-->`);
      ssrRenderList(unref(replies).data, (reply) => {
        _push(`<li>`);
        _push(ssrRenderComponent(_component_UserCommentReply, { instance: reply }, null, _parent));
        _push(`</li>`);
      });
      _push(`<!--]--></ol>`);
      if (unref(replies).next) {
        _push(`<button type="button" class="text-cyen-950 dark:text-white animate-bounce w-full"><svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-6 mx-auto"><path stroke-linecap="round" stroke-linejoin="round" d="m4.5 5.25 7.5 7.5 7.5-7.5m-15 6 7.5 7.5 7.5-7.5"></path></svg></button>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("pages/users/replies.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
//# sourceMappingURL=replies-6d2dVEIn.mjs.map
