import { unref, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrRenderAttr } from 'vue/server-renderer';
import { a as useNuxtApp, e as useMaghaleStore, f as useRouter } from './server.mjs';

const _sfc_main = {
  __name: "status",
  __ssrInlineRender: true,
  props: ["instance"],
  setup(__props) {
    const { $CustomAlert } = useNuxtApp();
    useMaghaleStore();
    const props = __props;
    const instance = props.instance;
    useRouter();
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(_attrs)}>`);
      if (unref(instance).work.status) {
        _push(`<select id="states" class="bg-zinc-50 border border-zinc-300 text-zinc-900 text-xs rounded-lg border-s-2 focus:ring-blue-500 focus:border-blue-500 block p-1 dark:bg-zinc-700 dark:border-zinc-600 dark:placeholder-zinc-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500"><option selected${ssrRenderAttr("value", 1)}>\u062F\u0631 \u0635\u0641 \u0645\u0637\u0627\u0644\u0639\u0647</option><option selected${ssrRenderAttr("value", 2)}>\u062F\u0631 \u062D\u0627\u0644 \u0645\u0637\u0627\u0644\u0639\u0647</option><option selected${ssrRenderAttr("value", 3)}>\u0631\u0648\u0632\u0646\u0627\u0645\u0647\u200C\u0648\u0627\u0631</option><option selected${ssrRenderAttr("value", 4)}>\u062A\u0646\u0647\u0627 \u06A9\u0645\u06CC \u0627\u0628\u0647\u0627\u0645</option><option selected${ssrRenderAttr("value", 5)}>\u0645\u0637\u0627\u0644\u0639\u0647 \u06A9\u0627\u0645\u0644</option><option selected${ssrRenderAttr("value", 6)}>\u0627\u0646\u0635\u0631\u0627\u0641 \u0627\u0632 \u0645\u0637\u0627\u0644\u0639\u0647</option></select>`);
      } else {
        _push(`<button class="bg-zinc-100 text-zinc-800 text-xs font-medium me-2 px-2.5 py-0.5 rounded-sm dark:bg-zinc-800 dark:text-zinc-400 border border-zinc-400"> \u0627\u0641\u0632\u0648\u062F\u0646 \u0628\u0647 \u0644\u06CC\u0633\u062A</button>`);
      }
      _push(`</div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/activity/status.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as _ };
//# sourceMappingURL=status-D3scJwW-.mjs.map
