import tailwindcss from "@tailwindcss/vite";
export default defineNuxtConfig({
  compatibilityDate: '2024-11-01',
  devtools: { enabled: true },
  css: ['~/assets/css/main.css'],
  vite: {
    plugins: [
      tailwindcss(),
    ],
  },
  modules: [
    "@pinia/nuxt",
    'pinia-plugin-persistedstate/nuxt',
    '@vite-pwa/nuxt',
  ],
  runtimeConfig: {
    public: {
      BaseUrl: "https://api.golchin.app/api-v1/",
      MediaUrl: "https://api.golchin.app",
      // BaseUrl: "http://127.0.0.1:8010/api-v1/",
      // MediaUrl: "http://127.0.0.1:8010",
      router: {
        // "Dashboard": "/users/dashboard",
        "Home": "/",
        "Login": "/users/login",
        "Signup": "/users/signup",
        "User": "/users/",
        "Information": "/users/information",
        "MyComments": "/users/comments/",
        "MyReplies": "/users/replies/",
        "Article": "/articles/",
        "ArticleEdit": "/articles/edit/",
        "ArticleAdd": "/articles/add",
        "Keyword": "/keywords/",
        "KeywordEdit": "/keywords/edit/",
        "KeywordAdd": "/keywords/add",
        "Author": "/authors/",
        "AuthorEdit": "/authors/edit/",
        "AuthorAdd": "/authors/add",
        "Paper": "/papers/",
        "PaperEdit": "/papers/edit/",
        "PaperAdd": "/papers/add",
        "Publisher": "/publishers/",
        "PublisherEdit": "/publishers/edit/",
        "PublisherAdd": "/publishers/add",
        "Journal": "/journals/",
        "JournalEdit": "/journals/edit/",
        "JournalAdd": "/journals/add",
        "Book": "/books/",
        "BookEdit": "/books/edit/",
        "BookAdd": "/books/add",
        "Chapter": "/chapters/",
        "ChapterEdit": "/chapters/edit/",
        "ChapterAdd": "/chapters/add",
        "Section": "/sections/",
        "SectionEdit": "/sections/edit/",
        "SectionAdd": "/sections/add",
        "Theorem": "/theorems/",
        "TheoremEdit": "/theorems/edit/",
        "TheoremAdd": "/theorems/add",
        "Hyper": "/hypers/",
        "HyperEdit": "/hypers/edit/",
        "HyperAdd": "/hypers/add",
        "Code": "/codes/",
        "CodeEdit": "/codes/edit/",
        "CodeAdd": "/codes/add",
        "Project": "/projects/",
        "ProjectEdit": "/projects/edit/",
        "ProjectAdd": "/projects/add",
        "Idea": "/ideas/",
        "IdeaEdit": "/ideas/edit/",
        "IdeaAdd": "/ideas/add",
        "IdeaAddKeyword": "/ideas/add-keyword",
        "IdeaAddPaper": "/ideas/add-paper",
        "IdeaAddSection": "/ideas/add-section",
        "IdeaAddCode": "/ideas/add-code",
        "IdeaTimeline": "/ideas/timeline",
        "Step": "/steps/",
        "StepEdit": "/steps/edit/",
        "StepAdd": "/steps/add",
        "Handout": "/handouts/",
        "HandoutEdit": "/handouts/edit/",
        "HandoutAdd": "/handouts/add",
        "Link": "/links/",
        "LinkEdit": "/links/edit/",
        "LinkAdd": "/links/add",
        "Website": "/websites/",
        "WebsiteEdit": "/websites/edit/",
        "WebsiteAdd": "/websites/add",
        "About": "/about",
        "FAQ": "/FAQ",
        "ProvinceAdd": "/provinces/add",
        "UniversityAdd": "/universities/add",
        
        "Maghale": "/",
        "HooshmandUser": "https://hooshmand.app/users/",
        'Nohakim': 'https://nohakim.ir',
        'Hooshmand': 'https://hooshmand.app',
        'Modir': 'https://modir.app',
        'Golchin': 'https://golchin.app',
        'GolchinUser': 'https://golchin.app/users/',
        'GolchinDashboard': 'https://golchin.app/users/dashboard',
        'UserSearch': 'https://golchin.app/users/search',
        'Sessions': 'https://golchin.app/users/sessions/',
      }
    }
  },
  pwa: {
    manifest: {
      name: 'سایت مقاله',
      short_name: 'مقاله',
      description: 'سایتی برای مطالعه مشترک علمی',
      lang: 'fa',
      orientation: 'portrait',
      icons: [
        {
          src: 'logo.png',
          sizes: '48x48',
          type: 'image/png',
        },
        {
          src: 'logo.png',
          sizes: '72x72',
          type: 'image/png',
        },
        {
          src: 'logo.png',
          sizes: '96x96',
          type: 'image/png',
        },
        {
          src: 'logo.png',
          sizes: '144x144',
          type: 'image/png',
        },
        {
          src: 'logo.png',
          sizes: '192x192',
          type: 'image/png',
        },
        {
          src: 'logo.png',
          sizes: '512x512',
          type: 'image/png',
        },
      ],
      "start_url": ".",
      "display": "standalone",
      "theme_color": "#09090b",
      "background_color": "#09090b",
    },
  },
})