import Swal from 'sweetalert2'
import { defineNuxtPlugin } from "#app/nuxt";

export default defineNuxtPlugin(() => {
  return {
    provide: {
      CustomAlert: (message, code) => {
        var icon;
        switch (code) {
          case 1:
          case 4:
            icon = 'success'
            break

          case 2:
          case 5:
            icon = 'warning'
            break

          case 3:
          case 6:
            icon = 'error'
            break

        }
        if (code < 4) {
          Swal.fire({ title: message, icon: icon });
        } else {
          const Toast = Swal.mixin({
            toast: true,
            position: 'center',
            showConfirmButton: false,
            timer: 3000,
            timerProgressBar: true,
            didOpen: (toast) => {
              toast.addEventListener('mouseenter', Swal.stopTimer)
              toast.addEventListener('mouseleave', Swal.resumeTimer)
            }
          })

          Toast.fire({
            title: message,
            icon: icon
          })
        }
      }
    }
  }
})
