export default defineNuxtPlugin((nuxtApp) => {
    const swapWithNext = (arr, index) => {
      if (index < 0 || index >= arr.length - 1) return arr
      const newArr = [...arr] // Create a copy to avoid direct mutation
      ;[newArr[index], newArr[index + 1]] = [newArr[index + 1], newArr[index]]
      return newArr
    }
  
    const swapWithPrevious = (arr, index) => {
      if (index <= 0 || index >= arr.length) return arr
      const newArr = [...arr] // Create a copy to avoid direct mutation
      ;[newArr[index - 1], newArr[index]] = [newArr[index], newArr[index - 1]]
      return newArr
    }
  
    return {
      provide: {
        arrayUtils: {
          swapWithNext,
          swapWithPrevious
        }
      }
    }
  })