export default defineNuxtPlugin((nuxtApp) => {
  // Function to convert Latin numbers to Persian numbers
  const toPersianNumbers = (input) => {
    if (typeof input === 'number') {
      input = input.toString();
    }
    if (typeof input !== 'string') {
      return input;
    }

    const latinNumbers = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9'];
    const persianNumbers = ['۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹'];

    return input.replace(/\d/g, (match) => {
      return persianNumbers[latinNumbers.indexOf(match)];
    });
  };

  // Inject the function into the Nuxt app
  nuxtApp.provide('toPersianNumbers', toPersianNumbers);
});