import { defineStore } from 'pinia'

export const useMaghaleStore = defineStore('maghaleStore', {
  state: () => ({
    token: '',
    isAuthenticated: false,
    search: '',
    wallet: 0,
    user: { id: 0, has_connection: false, get_image: '', get_title: '', abstract: ''},
    me: { id: 0, get_title: '', get_image: '' , abstract: '', golchin: 0},
    activity: { id: 0, type: '', get_title: '' },
    skillParent: 0,
    targetActivity: 0,
    hiddenLeft: true,
    hiddenWebsites: true,

    // activities
    handout: { id: 0, get_title: '' },
    link: { id: 0, get_title: '' },
    project: { id: 0, get_title: '' },
    hyper: { id: 0, get_title: '' },
    paper: { id: 0, get_title: '' },
    journal: { id: 0, get_title: '' },
    book: { id: 0, get_title: '' },
    chapter: { id: 0, get_title: '' },
    section: { id: 0, get_title: '' },
    publisher: { id: 0, get_title: '' },
    author: { id: 0, get_title: '' },
    article: { id: 0, get_title: '' },
    keyword: { id: 0, get_title: '' },
    idea: { id: 0, get_title: '', is_member: false },
    code: { id: 0, get_title: '' },
    website: { id: 0, get_title: '' },
    country: { id: 0, get_title: '' },
    province: { id: 0, get_title: '' },
  }),
  persist: true,
  actions: {
    setToken(event) {
      this.token = event
      this.isAuthenticated = true
      localStorage.setItem('token', event)
    },
    setUser(event) {
      this.user.id = event.id
      this.user.get_image = event.get_image
      this.user.get_title = event.get_title
      this.user.abstract = event.abstract
      this.user.has_connection = event.has_connection
    },
    setMyImage(event) {
      this.me.get_image = event
      localStorage.setItem('get_image', event)
    },
    setIsMember(event) {
      this.idea.is_member = event
    },
    setHiddenLeft(event) {
      this.hiddenLeft = event
    },
    setHiddenWebsites(event) {
      this.hiddenWebsites = event
    },
    setHidden() {
      this.hiddenWebsites = true
      this.hiddenLeft = true
    },
    setMyTitle(event) {
      this.me.get_title = event
      localStorage.setItem('get_title', event)
    },
    setSearch(event) {
      this.search = event
    },
    setMe(event) {
      this.me.golchin = event.golchin
      localStorage.setItem('golchin', event.golchin)
      this.me.id = event.id
      localStorage.setItem('id', event.id)
      this.me.get_title = event.get_title
      localStorage.setItem('get_title', event.get_title)
      this.me.get_image = event.get_image
      localStorage.setItem('get_image', event.get_image)
      this.me.abstract = event.abstract
      localStorage.setItem('abstract', event.abstract)
    },
    removeUser() {
      this.me.id = 0
      this.me.golchin = 0
      this.me.get_title = ''
      this.me.get_image = ''
      this.token = ''
      this.isAuthenticated = false
      localStorage.setItem('token', '')
    },
    setActivity(event) {
      if (event.activity.id) {
        this.activity.id = event.activity.id
      } else {
        this.activity.id = event.activity
      }
      this.activity.get_title = event.get_title
    },
    setActivityTitle(event) {
      this.activity.id = event.id
      this.activity.get_title = event.title
    },
    setType(event) {
      this.activity.type = event
    },
    setConnection(event) {
      this.user.has_connection = event
    },
    setTargetActivity(event) {
      this.targetActivity = event
    },

    // activities
    setHandoutId(event) { this.handout.id = event },
    setHandout(event) {
      this.handout.id = event.id
      this.handout.get_title = event.get_title
      this.setActivity(event)
    },
    setLinkId(event) { this.link.id = event },
    setLink(event) {
      this.link.id = event.id
      this.link.get_title = event.get_title
      this.setActivity(event)
    },
    setAuthorId(event) { this.author.id = event },
    setAuthor(event) {
      this.author.id = event.id
      this.author.get_title = event.get_title
      this.setActivity(event)
    },
    setArticleId(event) { this.article.id = event },
    setArticle(event) {
      this.article.id = event.id
      this.article.get_title = event.get_title
      this.setActivity(event)
    },
    setPublisherId(event) { this.publisher.id = event },
    setPublisher(event) {
      this.publisher.id = event.id
      this.publisher.get_title = event.get_title
      this.setActivity(event)
    },
    setBookId(event) { this.book.id = event },
    setBook(event) {
      this.book.id = event.id
      this.book.get_title = event.get_title
      this.setActivity(event)
    },
    setChapterId(event) { this.chapter.id = event },
    setChapter(event) {
      this.chapter.id = event.id
      this.chapter.get_title = event.get_title
      this.setActivity(event)
    },
    setSectionId(event) { this.section.id = event },
    setSection(event) {
      this.section.id = event.id
      this.section.get_title = event.get_title
      this.setActivity(event)
    },
    setJournalId(event) { this.journal.id = event },
    setJournal(event) {
      this.journal.id = event.id
      this.journal.get_title = event.get_title
      this.setActivity(event)
    },
    setPaperId(event) { this.paper.id = event },
    setPaper(event) {
      this.paper.id = event.id
      this.paper.get_title = event.get_title
      this.setActivity(event)
    },
    setKeywordId(event) { this.keyword.id = event },
    setKeyword(event) {
      this.keyword.id = event.id
      this.keyword.get_title = event.get_title
      this.setActivity(event)
    },
    setHyperId(event) { this.hyper.id = event },
    setHyper(event) {
      this.hyper.id = event.id
      this.hyper.get_title = event.get_title
      this.setActivity(event)
    },
    setProjectId(event) { this.project.id = event },
    setProject(event) {
      this.project.id = event.id
      this.project.get_title = event.get_title
      this.setActivity(event)
    },
    setIdeaId(event) { this.idea.id = event },
    setIdea(event) {
      console.log(event.id);
      
      this.idea.id = event.id
      this.idea.get_title = event.get_title
      this.setActivity(event)
    },
    setCodeId(event) { this.code.id = event },
    setCode(event) {
      console.log(event.id);
      
      this.code.id = event.id
      this.code.get_title = event.get_title
      this.setActivity(event)
    },
    setWebsiteId(event) { this.website.id = event },
    setWebsite(event) {
      console.log(event.id);
      
      this.website.id = event.id
      this.website.get_title = event.get_title
      this.setActivity(event)
    },
    setCountryId(event) { this.country.id = event },
    setCountry(event) {
      this.country.id = event.id
      this.country.get_title = event.get_title
      this.setActivity(event)
    },
    setProvinceId(event) { this.province.id = event },
    setProvince(event) {
      this.province.id = event.id
      this.province.get_title = event.get_title
      this.setActivity(event)
    },
  },
})